package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, RoleNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListInstanceProfilesForRoleRequest(
    roleName: RoleNameType,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest = {
    import ListInstanceProfilesForRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListInstanceProfilesForRoleRequest.ReadOnly =
    zio.aws.iam.model.ListInstanceProfilesForRoleRequest.wrap(buildAwsValue())
}
object ListInstanceProfilesForRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListInstanceProfilesForRoleRequest =
      zio.aws.iam.model.ListInstanceProfilesForRoleRequest(
        roleName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def roleName: RoleNameType
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest
  ) extends zio.aws.iam.model.ListInstanceProfilesForRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest
  ): zio.aws.iam.model.ListInstanceProfilesForRoleRequest.ReadOnly =
    new Wrapper(impl)
}
