package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  ExistingUserNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMfaDevicesRequest(
    userName: Option[ExistingUserNameType] = None,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest = {
    import ListMfaDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListMfaDevicesRequest.ReadOnly =
    zio.aws.iam.model.ListMfaDevicesRequest.wrap(buildAwsValue())
}
object ListMfaDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListMfaDevicesRequest =
      zio.aws.iam.model.ListMfaDevicesRequest(
        userName.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def userName: Option[ExistingUserNameType]
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest
  ) extends zio.aws.iam.model.ListMfaDevicesRequest.ReadOnly {
    override val userName: Option[ExistingUserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest
  ): zio.aws.iam.model.ListMfaDevicesRequest.ReadOnly = new Wrapper(impl)
}
