package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMfaDevicesResponse(
    mfaDevices: Iterable[zio.aws.iam.model.MFADevice],
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse = {
    import ListMfaDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse
      .builder()
      .mfaDevices(mfaDevices.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly =
    zio.aws.iam.model.ListMfaDevicesResponse.wrap(buildAwsValue())
}
object ListMfaDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListMfaDevicesResponse =
      zio.aws.iam.model.ListMfaDevicesResponse(
        mfaDevices.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def mfaDevices: List[zio.aws.iam.model.MFADevice.ReadOnly]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getMfaDevices
        : ZIO[Any, Nothing, List[zio.aws.iam.model.MFADevice.ReadOnly]] =
      ZIO.succeed(mfaDevices)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse
  ) extends zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly {
    override val mfaDevices: List[zio.aws.iam.model.MFADevice.ReadOnly] = impl
      .mfaDevices()
      .asScala
      .map { item =>
        zio.aws.iam.model.MFADevice.wrap(item)
      }
      .toList
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse
  ): zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly = new Wrapper(impl)
}
