package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOpenIdConnectProviderTagsRequest(
    openIDConnectProviderArn: ArnType,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest = {
    import ListOpenIdConnectProviderTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest.ReadOnly =
    zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest.wrap(buildAwsValue())
}
object ListOpenIdConnectProviderTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest =
      zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest(
        openIDConnectProviderArn,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def openIDConnectProviderArn: ArnType
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest
  ) extends zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest
  ): zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest.ReadOnly =
    new Wrapper(impl)
}
