package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ServiceNamespaceType, ArnType, MarkerType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPoliciesGrantingServiceAccessRequest(
    marker: Option[MarkerType] = None,
    arn: ArnType,
    serviceNamespaces: Iterable[ServiceNamespaceType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest = {
    import ListPoliciesGrantingServiceAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest
      .builder()
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .arn(ArnType.unwrap(arn): java.lang.String)
      .serviceNamespaces(serviceNamespaces.map { item =>
        ServiceNamespaceType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest.ReadOnly =
    zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest
      .wrap(buildAwsValue())
}
object ListPoliciesGrantingServiceAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest =
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest(
        marker.map(value => value),
        arn,
        serviceNamespaces
      )
    def marker: Option[MarkerType]
    def arn: ArnType
    def serviceNamespaces: List[ServiceNamespaceType]
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getServiceNamespaces: ZIO[Any, Nothing, List[ServiceNamespaceType]] =
      ZIO.succeed(serviceNamespaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest
  ) extends zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest.ReadOnly {
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val serviceNamespaces: List[ServiceNamespaceType] = impl
      .serviceNamespaces()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.ServiceNamespaceType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest
  ): zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest.ReadOnly =
    new Wrapper(impl)
}
