package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  PolicyPathType,
  BooleanType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPoliciesRequest(
    scope: Option[zio.aws.iam.model.PolicyScopeType] = None,
    onlyAttached: Option[BooleanType] = None,
    pathPrefix: Option[PolicyPathType] = None,
    policyUsageFilter: Option[zio.aws.iam.model.PolicyUsageType] = None,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPoliciesRequest = {
    import ListPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPoliciesRequest
      .builder()
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(
        onlyAttached.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.onlyAttached)
      .optionallyWith(
        pathPrefix.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(policyUsageFilter.map(value => value.unwrap))(
        _.policyUsageFilter
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListPoliciesRequest.ReadOnly =
    zio.aws.iam.model.ListPoliciesRequest.wrap(buildAwsValue())
}
object ListPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListPoliciesRequest =
      zio.aws.iam.model.ListPoliciesRequest(
        scope.map(value => value),
        onlyAttached.map(value => value),
        pathPrefix.map(value => value),
        policyUsageFilter.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def scope: Option[zio.aws.iam.model.PolicyScopeType]
    def onlyAttached: Option[BooleanType]
    def pathPrefix: Option[PolicyPathType]
    def policyUsageFilter: Option[zio.aws.iam.model.PolicyUsageType]
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getScope: ZIO[Any, AwsError, zio.aws.iam.model.PolicyScopeType] =
      AwsError.unwrapOptionField("scope", scope)
    def getOnlyAttached: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("onlyAttached", onlyAttached)
    def getPathPrefix: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getPolicyUsageFilter
        : ZIO[Any, AwsError, zio.aws.iam.model.PolicyUsageType] =
      AwsError.unwrapOptionField("policyUsageFilter", policyUsageFilter)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesRequest
  ) extends zio.aws.iam.model.ListPoliciesRequest.ReadOnly {
    override val scope: Option[zio.aws.iam.model.PolicyScopeType] = scala
      .Option(impl.scope())
      .map(value => zio.aws.iam.model.PolicyScopeType.wrap(value))
    override val onlyAttached: Option[BooleanType] = scala
      .Option(impl.onlyAttached())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val pathPrefix: Option[PolicyPathType] = scala
      .Option(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val policyUsageFilter: Option[zio.aws.iam.model.PolicyUsageType] =
      scala
        .Option(impl.policyUsageFilter())
        .map(value => zio.aws.iam.model.PolicyUsageType.wrap(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesRequest
  ): zio.aws.iam.model.ListPoliciesRequest.ReadOnly = new Wrapper(impl)
}
