package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPolicyTagsRequest(
    policyArn: ArnType,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest = {
    import ListPolicyTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListPolicyTagsRequest.ReadOnly =
    zio.aws.iam.model.ListPolicyTagsRequest.wrap(buildAwsValue())
}
object ListPolicyTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListPolicyTagsRequest =
      zio.aws.iam.model.ListPolicyTagsRequest(
        policyArn,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def policyArn: ArnType
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest
  ) extends zio.aws.iam.model.ListPolicyTagsRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest
  ): zio.aws.iam.model.ListPolicyTagsRequest.ReadOnly = new Wrapper(impl)
}
