package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPolicyTagsResponse(
    tags: Iterable[zio.aws.iam.model.Tag],
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse = {
    import ListPolicyTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly =
    zio.aws.iam.model.ListPolicyTagsResponse.wrap(buildAwsValue())
}
object ListPolicyTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListPolicyTagsResponse =
      zio.aws.iam.model.ListPolicyTagsResponse(
        tags.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse
  ) extends zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly {
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse
  ): zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly = new Wrapper(impl)
}
