package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPolicyVersionsResponse(
    versions: Option[Iterable[zio.aws.iam.model.PolicyVersion]] = None,
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse = {
    import ListPolicyVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse
      .builder()
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly =
    zio.aws.iam.model.ListPolicyVersionsResponse.wrap(buildAwsValue())
}
object ListPolicyVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListPolicyVersionsResponse =
      zio.aws.iam.model.ListPolicyVersionsResponse(
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def versions: Option[List[zio.aws.iam.model.PolicyVersion.ReadOnly]]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getVersions
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyVersion.ReadOnly]] =
      AwsError.unwrapOptionField("versions", versions)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse
  ) extends zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly {
    override val versions
        : Option[List[zio.aws.iam.model.PolicyVersion.ReadOnly]] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyVersion.wrap(item)
        }.toList
      )
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse
  ): zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly = new Wrapper(impl)
}
