package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ResponseMarkerType,
  BooleanType,
  PolicyNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRolePoliciesResponse(
    policyNames: Iterable[PolicyNameType],
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse = {
    import ListRolePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse
      .builder()
      .policyNames(policyNames.map { item =>
        PolicyNameType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly =
    zio.aws.iam.model.ListRolePoliciesResponse.wrap(buildAwsValue())
}
object ListRolePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListRolePoliciesResponse =
      zio.aws.iam.model.ListRolePoliciesResponse(
        policyNames,
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def policyNames: List[PolicyNameType]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getPolicyNames: ZIO[Any, Nothing, List[PolicyNameType]] =
      ZIO.succeed(policyNames)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse
  ) extends zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly {
    override val policyNames: List[PolicyNameType] = impl
      .policyNames()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.PolicyNameType(item)
      }
      .toList
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse
  ): zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly = new Wrapper(impl)
}
