package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, PathPrefixType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRolesRequest(
    pathPrefix: Option[PathPrefixType] = None,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListRolesRequest = {
    import ListRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListRolesRequest
      .builder()
      .optionallyWith(
        pathPrefix.map(value => PathPrefixType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListRolesRequest.ReadOnly =
    zio.aws.iam.model.ListRolesRequest.wrap(buildAwsValue())
}
object ListRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListRolesRequest =
      zio.aws.iam.model.ListRolesRequest(
        pathPrefix.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def pathPrefix: Option[PathPrefixType]
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getPathPrefix: ZIO[Any, AwsError, PathPrefixType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListRolesRequest
  ) extends zio.aws.iam.model.ListRolesRequest.ReadOnly {
    override val pathPrefix: Option[PathPrefixType] = scala
      .Option(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PathPrefixType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListRolesRequest
  ): zio.aws.iam.model.ListRolesRequest.ReadOnly = new Wrapper(impl)
}
