package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSamlProviderTagsRequest(
    samlProviderArn: ArnType,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest = {
    import ListSamlProviderTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest
      .builder()
      .samlProviderArn(ArnType.unwrap(samlProviderArn): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListSamlProviderTagsRequest.ReadOnly =
    zio.aws.iam.model.ListSamlProviderTagsRequest.wrap(buildAwsValue())
}
object ListSamlProviderTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListSamlProviderTagsRequest =
      zio.aws.iam.model.ListSamlProviderTagsRequest(
        samlProviderArn,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def samlProviderArn: ArnType
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getSamlProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(samlProviderArn)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest
  ) extends zio.aws.iam.model.ListSamlProviderTagsRequest.ReadOnly {
    override val samlProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.samlProviderArn())
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest
  ): zio.aws.iam.model.ListSamlProviderTagsRequest.ReadOnly = new Wrapper(impl)
}
