package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServerCertificatesResponse(
    serverCertificateMetadataList: Iterable[
      zio.aws.iam.model.ServerCertificateMetadata
    ],
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse = {
    import ListServerCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse
      .builder()
      .serverCertificateMetadataList(serverCertificateMetadataList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly =
    zio.aws.iam.model.ListServerCertificatesResponse.wrap(buildAwsValue())
}
object ListServerCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListServerCertificatesResponse =
      zio.aws.iam.model.ListServerCertificatesResponse(
        serverCertificateMetadataList.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def serverCertificateMetadataList
        : List[zio.aws.iam.model.ServerCertificateMetadata.ReadOnly]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getServerCertificateMetadataList: ZIO[Any, Nothing, List[
      zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
    ]] = ZIO.succeed(serverCertificateMetadataList)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse
  ) extends zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly {
    override val serverCertificateMetadataList
        : List[zio.aws.iam.model.ServerCertificateMetadata.ReadOnly] = impl
      .serverCertificateMetadataList()
      .asScala
      .map { item =>
        zio.aws.iam.model.ServerCertificateMetadata.wrap(item)
      }
      .toList
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse
  ): zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
