package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ServiceName, UserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServiceSpecificCredentialsRequest(
    userName: Option[UserNameType] = None,
    serviceName: Option[ServiceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest = {
    import ListServiceSpecificCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest
      .builder()
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListServiceSpecificCredentialsRequest.ReadOnly =
    zio.aws.iam.model.ListServiceSpecificCredentialsRequest
      .wrap(buildAwsValue())
}
object ListServiceSpecificCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListServiceSpecificCredentialsRequest =
      zio.aws.iam.model.ListServiceSpecificCredentialsRequest(
        userName.map(value => value),
        serviceName.map(value => value)
      )
    def userName: Option[UserNameType]
    def serviceName: Option[ServiceName]
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest
  ) extends zio.aws.iam.model.ListServiceSpecificCredentialsRequest.ReadOnly {
    override val userName: Option[UserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val serviceName: Option[ServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.iam.model.primitives.ServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest
  ): zio.aws.iam.model.ListServiceSpecificCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
