package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServiceSpecificCredentialsResponse(
    serviceSpecificCredentials: Option[
      Iterable[zio.aws.iam.model.ServiceSpecificCredentialMetadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse = {
    import ListServiceSpecificCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse
      .builder()
      .optionallyWith(
        serviceSpecificCredentials.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceSpecificCredentials)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly =
    zio.aws.iam.model.ListServiceSpecificCredentialsResponse
      .wrap(buildAwsValue())
}
object ListServiceSpecificCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListServiceSpecificCredentialsResponse =
      zio.aws.iam.model.ListServiceSpecificCredentialsResponse(
        serviceSpecificCredentials.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceSpecificCredentials: Option[
      List[zio.aws.iam.model.ServiceSpecificCredentialMetadata.ReadOnly]
    ]
    def getServiceSpecificCredentials: ZIO[Any, AwsError, List[
      zio.aws.iam.model.ServiceSpecificCredentialMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceSpecificCredentials",
      serviceSpecificCredentials
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse
  ) extends zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly {
    override val serviceSpecificCredentials: Option[
      List[zio.aws.iam.model.ServiceSpecificCredentialMetadata.ReadOnly]
    ] = scala
      .Option(impl.serviceSpecificCredentials())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.ServiceSpecificCredentialMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse
  ): zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
