package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVirtualMfaDevicesRequest(
    assignmentStatus: Option[zio.aws.iam.model.AssignmentStatusType] = None,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest = {
    import ListVirtualMfaDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest
      .builder()
      .optionallyWith(assignmentStatus.map(value => value.unwrap))(
        _.assignmentStatus
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListVirtualMfaDevicesRequest.ReadOnly =
    zio.aws.iam.model.ListVirtualMfaDevicesRequest.wrap(buildAwsValue())
}
object ListVirtualMfaDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListVirtualMfaDevicesRequest =
      zio.aws.iam.model.ListVirtualMfaDevicesRequest(
        assignmentStatus.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def assignmentStatus: Option[zio.aws.iam.model.AssignmentStatusType]
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getAssignmentStatus
        : ZIO[Any, AwsError, zio.aws.iam.model.AssignmentStatusType] =
      AwsError.unwrapOptionField("assignmentStatus", assignmentStatus)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest
  ) extends zio.aws.iam.model.ListVirtualMfaDevicesRequest.ReadOnly {
    override val assignmentStatus
        : Option[zio.aws.iam.model.AssignmentStatusType] = scala
      .Option(impl.assignmentStatus())
      .map(value => zio.aws.iam.model.AssignmentStatusType.wrap(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest
  ): zio.aws.iam.model.ListVirtualMfaDevicesRequest.ReadOnly = new Wrapper(impl)
}
