package zio.aws.iam.model
import zio.aws.iam.model.primitives.BooleanType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OrganizationsDecisionDetail(
    allowedByOrganizations: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail = {
    import OrganizationsDecisionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail
      .builder()
      .optionallyWith(
        allowedByOrganizations.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.allowedByOrganizations)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.OrganizationsDecisionDetail.ReadOnly =
    zio.aws.iam.model.OrganizationsDecisionDetail.wrap(buildAwsValue())
}
object OrganizationsDecisionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.OrganizationsDecisionDetail =
      zio.aws.iam.model
        .OrganizationsDecisionDetail(allowedByOrganizations.map(value => value))
    def allowedByOrganizations: Option[BooleanType]
    def getAllowedByOrganizations: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("allowedByOrganizations", allowedByOrganizations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail
  ) extends zio.aws.iam.model.OrganizationsDecisionDetail.ReadOnly {
    override val allowedByOrganizations: Option[BooleanType] = scala
      .Option(impl.allowedByOrganizations())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail
  ): zio.aws.iam.model.OrganizationsDecisionDetail.ReadOnly = new Wrapper(impl)
}
