package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  BooleanType,
  BooleanObjectType,
  MinimumPasswordLengthType,
  MaxPasswordAgeType,
  PasswordReusePreventionType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PasswordPolicy(
    minimumPasswordLength: Option[MinimumPasswordLengthType] = None,
    requireSymbols: Option[BooleanType] = None,
    requireNumbers: Option[BooleanType] = None,
    requireUppercaseCharacters: Option[BooleanType] = None,
    requireLowercaseCharacters: Option[BooleanType] = None,
    allowUsersToChangePassword: Option[BooleanType] = None,
    expirePasswords: Option[BooleanType] = None,
    maxPasswordAge: Option[MaxPasswordAgeType] = None,
    passwordReusePrevention: Option[PasswordReusePreventionType] = None,
    hardExpiry: Option[BooleanObjectType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PasswordPolicy = {
    import PasswordPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PasswordPolicy
      .builder()
      .optionallyWith(
        minimumPasswordLength.map(value =>
          MinimumPasswordLengthType.unwrap(value): Integer
        )
      )(_.minimumPasswordLength)
      .optionallyWith(
        requireSymbols.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireSymbols)
      .optionallyWith(
        requireNumbers.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireNumbers)
      .optionallyWith(
        requireUppercaseCharacters.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireUppercaseCharacters)
      .optionallyWith(
        requireLowercaseCharacters.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireLowercaseCharacters)
      .optionallyWith(
        allowUsersToChangePassword.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.allowUsersToChangePassword)
      .optionallyWith(
        expirePasswords.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.expirePasswords)
      .optionallyWith(
        maxPasswordAge.map(value => MaxPasswordAgeType.unwrap(value): Integer)
      )(_.maxPasswordAge)
      .optionallyWith(
        passwordReusePrevention.map(value =>
          PasswordReusePreventionType.unwrap(value): Integer
        )
      )(_.passwordReusePrevention)
      .optionallyWith(
        hardExpiry.map(value =>
          BooleanObjectType.unwrap(value): java.lang.Boolean
        )
      )(_.hardExpiry)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PasswordPolicy.ReadOnly =
    zio.aws.iam.model.PasswordPolicy.wrap(buildAwsValue())
}
object PasswordPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.PasswordPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PasswordPolicy =
      zio.aws.iam.model.PasswordPolicy(
        minimumPasswordLength.map(value => value),
        requireSymbols.map(value => value),
        requireNumbers.map(value => value),
        requireUppercaseCharacters.map(value => value),
        requireLowercaseCharacters.map(value => value),
        allowUsersToChangePassword.map(value => value),
        expirePasswords.map(value => value),
        maxPasswordAge.map(value => value),
        passwordReusePrevention.map(value => value),
        hardExpiry.map(value => value)
      )
    def minimumPasswordLength: Option[MinimumPasswordLengthType]
    def requireSymbols: Option[BooleanType]
    def requireNumbers: Option[BooleanType]
    def requireUppercaseCharacters: Option[BooleanType]
    def requireLowercaseCharacters: Option[BooleanType]
    def allowUsersToChangePassword: Option[BooleanType]
    def expirePasswords: Option[BooleanType]
    def maxPasswordAge: Option[MaxPasswordAgeType]
    def passwordReusePrevention: Option[PasswordReusePreventionType]
    def hardExpiry: Option[BooleanObjectType]
    def getMinimumPasswordLength
        : ZIO[Any, AwsError, MinimumPasswordLengthType] =
      AwsError.unwrapOptionField("minimumPasswordLength", minimumPasswordLength)
    def getRequireSymbols: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireSymbols", requireSymbols)
    def getRequireNumbers: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireNumbers", requireNumbers)
    def getRequireUppercaseCharacters: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "requireUppercaseCharacters",
        requireUppercaseCharacters
      )
    def getRequireLowercaseCharacters: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "requireLowercaseCharacters",
        requireLowercaseCharacters
      )
    def getAllowUsersToChangePassword: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "allowUsersToChangePassword",
        allowUsersToChangePassword
      )
    def getExpirePasswords: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("expirePasswords", expirePasswords)
    def getMaxPasswordAge: ZIO[Any, AwsError, MaxPasswordAgeType] =
      AwsError.unwrapOptionField("maxPasswordAge", maxPasswordAge)
    def getPasswordReusePrevention
        : ZIO[Any, AwsError, PasswordReusePreventionType] = AwsError
      .unwrapOptionField("passwordReusePrevention", passwordReusePrevention)
    def getHardExpiry: ZIO[Any, AwsError, BooleanObjectType] =
      AwsError.unwrapOptionField("hardExpiry", hardExpiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PasswordPolicy
  ) extends zio.aws.iam.model.PasswordPolicy.ReadOnly {
    override val minimumPasswordLength: Option[MinimumPasswordLengthType] =
      scala
        .Option(impl.minimumPasswordLength())
        .map(value =>
          zio.aws.iam.model.primitives.MinimumPasswordLengthType(value)
        )
    override val requireSymbols: Option[BooleanType] = scala
      .Option(impl.requireSymbols())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val requireNumbers: Option[BooleanType] = scala
      .Option(impl.requireNumbers())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val requireUppercaseCharacters: Option[BooleanType] = scala
      .Option(impl.requireUppercaseCharacters())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val requireLowercaseCharacters: Option[BooleanType] = scala
      .Option(impl.requireLowercaseCharacters())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val allowUsersToChangePassword: Option[BooleanType] = scala
      .Option(impl.allowUsersToChangePassword())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val expirePasswords: Option[BooleanType] = scala
      .Option(impl.expirePasswords())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val maxPasswordAge: Option[MaxPasswordAgeType] = scala
      .Option(impl.maxPasswordAge())
      .map(value => zio.aws.iam.model.primitives.MaxPasswordAgeType(value))
    override val passwordReusePrevention: Option[PasswordReusePreventionType] =
      scala
        .Option(impl.passwordReusePrevention())
        .map(value =>
          zio.aws.iam.model.primitives.PasswordReusePreventionType(value)
        )
    override val hardExpiry: Option[BooleanObjectType] = scala
      .Option(impl.hardExpiry())
      .map(value => zio.aws.iam.model.primitives.BooleanObjectType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PasswordPolicy
  ): zio.aws.iam.model.PasswordPolicy.ReadOnly = new Wrapper(impl)
}
