package zio.aws.iam.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  PolicyNameType,
  PolicyVersionIdType,
  AttachmentCountType,
  ArnType,
  BooleanType,
  IdType,
  DateType,
  PolicyPathType,
  PolicyDescriptionType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Policy(
    policyName: Option[PolicyNameType] = None,
    policyId: Option[IdType] = None,
    arn: Option[ArnType] = None,
    path: Option[PolicyPathType] = None,
    defaultVersionId: Option[PolicyVersionIdType] = None,
    attachmentCount: Option[AttachmentCountType] = None,
    permissionsBoundaryUsageCount: Option[AttachmentCountType] = None,
    isAttachable: Option[BooleanType] = None,
    description: Option[PolicyDescriptionType] = None,
    createDate: Option[DateType] = None,
    updateDate: Option[DateType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.Policy = {
    import Policy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.Policy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyNameType.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        path.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        defaultVersionId.map(value =>
          PolicyVersionIdType.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        attachmentCount.map(value => AttachmentCountType.unwrap(value): Integer)
      )(_.attachmentCount)
      .optionallyWith(
        permissionsBoundaryUsageCount.map(value =>
          AttachmentCountType.unwrap(value): Integer
        )
      )(_.permissionsBoundaryUsageCount)
      .optionallyWith(
        isAttachable.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isAttachable)
      .optionallyWith(
        description.map(value =>
          PolicyDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(updateDate.map(value => DateType.unwrap(value): Instant))(
        _.updateDate
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.Policy.ReadOnly =
    zio.aws.iam.model.Policy.wrap(buildAwsValue())
}
object Policy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.Policy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.Policy = zio.aws.iam.model.Policy(
      policyName.map(value => value),
      policyId.map(value => value),
      arn.map(value => value),
      path.map(value => value),
      defaultVersionId.map(value => value),
      attachmentCount.map(value => value),
      permissionsBoundaryUsageCount.map(value => value),
      isAttachable.map(value => value),
      description.map(value => value),
      createDate.map(value => value),
      updateDate.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def policyName: Option[PolicyNameType]
    def policyId: Option[IdType]
    def arn: Option[ArnType]
    def path: Option[PolicyPathType]
    def defaultVersionId: Option[PolicyVersionIdType]
    def attachmentCount: Option[AttachmentCountType]
    def permissionsBoundaryUsageCount: Option[AttachmentCountType]
    def isAttachable: Option[BooleanType]
    def description: Option[PolicyDescriptionType]
    def createDate: Option[DateType]
    def updateDate: Option[DateType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPolicyName: ZIO[Any, AwsError, PolicyNameType] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getPath: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("path", path)
    def getDefaultVersionId: ZIO[Any, AwsError, PolicyVersionIdType] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getAttachmentCount: ZIO[Any, AwsError, AttachmentCountType] =
      AwsError.unwrapOptionField("attachmentCount", attachmentCount)
    def getPermissionsBoundaryUsageCount
        : ZIO[Any, AwsError, AttachmentCountType] = AwsError.unwrapOptionField(
      "permissionsBoundaryUsageCount",
      permissionsBoundaryUsageCount
    )
    def getIsAttachable: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isAttachable", isAttachable)
    def getDescription: ZIO[Any, AwsError, PolicyDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getUpdateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("updateDate", updateDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.Policy
  ) extends zio.aws.iam.model.Policy.ReadOnly {
    override val policyName: Option[PolicyNameType] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.iam.model.primitives.PolicyNameType(value))
    override val policyId: Option[IdType] = scala
      .Option(impl.policyId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val path: Option[PolicyPathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val defaultVersionId: Option[PolicyVersionIdType] = scala
      .Option(impl.defaultVersionId())
      .map(value => zio.aws.iam.model.primitives.PolicyVersionIdType(value))
    override val attachmentCount: Option[AttachmentCountType] = scala
      .Option(impl.attachmentCount())
      .map(value => zio.aws.iam.model.primitives.AttachmentCountType(value))
    override val permissionsBoundaryUsageCount: Option[AttachmentCountType] =
      scala
        .Option(impl.permissionsBoundaryUsageCount())
        .map(value => zio.aws.iam.model.primitives.AttachmentCountType(value))
    override val isAttachable: Option[BooleanType] = scala
      .Option(impl.isAttachable())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val description: Option[PolicyDescriptionType] = scala
      .Option(impl.description())
      .map(value => zio.aws.iam.model.primitives.PolicyDescriptionType(value))
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val updateDate: Option[DateType] = scala
      .Option(impl.updateDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.Policy
  ): zio.aws.iam.model.Policy.ReadOnly = new Wrapper(impl)
}
