package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyScopeType {
  def unwrap: software.amazon.awssdk.services.iam.model.PolicyScopeType
}
object PolicyScopeType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.PolicyScopeType
  ): zio.aws.iam.model.PolicyScopeType = value match {
    case software.amazon.awssdk.services.iam.model.PolicyScopeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.PolicyScopeType.ALL =>
      val r = All
      r
    case software.amazon.awssdk.services.iam.model.PolicyScopeType.AWS =>
      val r = AWS
      r
    case software.amazon.awssdk.services.iam.model.PolicyScopeType.LOCAL =>
      val r = Local
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.PolicyScopeType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyScopeType =
      software.amazon.awssdk.services.iam.model.PolicyScopeType.UNKNOWN_TO_SDK_VERSION
  }
  case object All extends zio.aws.iam.model.PolicyScopeType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyScopeType =
      software.amazon.awssdk.services.iam.model.PolicyScopeType.ALL
  }
  case object AWS extends zio.aws.iam.model.PolicyScopeType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyScopeType =
      software.amazon.awssdk.services.iam.model.PolicyScopeType.AWS
  }
  case object Local extends zio.aws.iam.model.PolicyScopeType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyScopeType =
      software.amazon.awssdk.services.iam.model.PolicyScopeType.LOCAL
  }
}
