package zio.aws.iam.model
import zio.aws.iam.model.primitives.{IdType, UserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PolicyUser(
    userName: Option[UserNameType] = None,
    userId: Option[IdType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.PolicyUser = {
    import PolicyUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PolicyUser
      .builder()
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        userId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PolicyUser.ReadOnly =
    zio.aws.iam.model.PolicyUser.wrap(buildAwsValue())
}
object PolicyUser {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.PolicyUser] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PolicyUser = zio.aws.iam.model
      .PolicyUser(userName.map(value => value), userId.map(value => value))
    def userName: Option[UserNameType]
    def userId: Option[IdType]
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getUserId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PolicyUser
  ) extends zio.aws.iam.model.PolicyUser.ReadOnly {
    override val userName: Option[UserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val userId: Option[IdType] = scala
      .Option(impl.userId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PolicyUser
  ): zio.aws.iam.model.PolicyUser.ReadOnly = new Wrapper(impl)
}
