package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  DateType,
  BooleanType,
  PolicyVersionIdType,
  PolicyDocumentType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PolicyVersion(
    document: Option[PolicyDocumentType] = None,
    versionId: Option[PolicyVersionIdType] = None,
    isDefaultVersion: Option[BooleanType] = None,
    createDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PolicyVersion = {
    import PolicyVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PolicyVersion
      .builder()
      .optionallyWith(
        document.map(value =>
          PolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.document)
      .optionallyWith(
        versionId.map(value =>
          PolicyVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PolicyVersion.ReadOnly =
    zio.aws.iam.model.PolicyVersion.wrap(buildAwsValue())
}
object PolicyVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.PolicyVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PolicyVersion =
      zio.aws.iam.model.PolicyVersion(
        document.map(value => value),
        versionId.map(value => value),
        isDefaultVersion.map(value => value),
        createDate.map(value => value)
      )
    def document: Option[PolicyDocumentType]
    def versionId: Option[PolicyVersionIdType]
    def isDefaultVersion: Option[BooleanType]
    def createDate: Option[DateType]
    def getDocument: ZIO[Any, AwsError, PolicyDocumentType] =
      AwsError.unwrapOptionField("document", document)
    def getVersionId: ZIO[Any, AwsError, PolicyVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PolicyVersion
  ) extends zio.aws.iam.model.PolicyVersion.ReadOnly {
    override val document: Option[PolicyDocumentType] = scala
      .Option(impl.document())
      .map(value => zio.aws.iam.model.primitives.PolicyDocumentType(value))
    override val versionId: Option[PolicyVersionIdType] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.iam.model.primitives.PolicyVersionIdType(value))
    override val isDefaultVersion: Option[BooleanType] = scala
      .Option(impl.isDefaultVersion())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PolicyVersion
  ): zio.aws.iam.model.PolicyVersion.ReadOnly = new Wrapper(impl)
}
