package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ServiceSpecificCredentialId, UserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetServiceSpecificCredentialRequest(
    userName: Option[UserNameType] = None,
    serviceSpecificCredentialId: ServiceSpecificCredentialId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest = {
    import ResetServiceSpecificCredentialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest
      .builder()
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .serviceSpecificCredentialId(
        ServiceSpecificCredentialId.unwrap(
          serviceSpecificCredentialId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ResetServiceSpecificCredentialRequest.ReadOnly =
    zio.aws.iam.model.ResetServiceSpecificCredentialRequest
      .wrap(buildAwsValue())
}
object ResetServiceSpecificCredentialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ResetServiceSpecificCredentialRequest =
      zio.aws.iam.model.ResetServiceSpecificCredentialRequest(
        userName.map(value => value),
        serviceSpecificCredentialId
      )
    def userName: Option[UserNameType]
    def serviceSpecificCredentialId: ServiceSpecificCredentialId
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getServiceSpecificCredentialId
        : ZIO[Any, Nothing, ServiceSpecificCredentialId] =
      ZIO.succeed(serviceSpecificCredentialId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest
  ) extends zio.aws.iam.model.ResetServiceSpecificCredentialRequest.ReadOnly {
    override val userName: Option[UserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val serviceSpecificCredentialId: ServiceSpecificCredentialId =
      zio.aws.iam.model.primitives
        .ServiceSpecificCredentialId(impl.serviceSpecificCredentialId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest
  ): zio.aws.iam.model.ResetServiceSpecificCredentialRequest.ReadOnly =
    new Wrapper(impl)
}
