package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetServiceSpecificCredentialResponse(
    serviceSpecificCredential: Option[
      zio.aws.iam.model.ServiceSpecificCredential
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse = {
    import ResetServiceSpecificCredentialResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse
      .builder()
      .optionallyWith(
        serviceSpecificCredential.map(value => value.buildAwsValue())
      )(_.serviceSpecificCredential)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly =
    zio.aws.iam.model.ResetServiceSpecificCredentialResponse
      .wrap(buildAwsValue())
}
object ResetServiceSpecificCredentialResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ResetServiceSpecificCredentialResponse =
      zio.aws.iam.model.ResetServiceSpecificCredentialResponse(
        serviceSpecificCredential.map(value => value.asEditable)
      )
    def serviceSpecificCredential
        : Option[zio.aws.iam.model.ServiceSpecificCredential.ReadOnly]
    def getServiceSpecificCredential: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.ServiceSpecificCredential.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSpecificCredential",
      serviceSpecificCredential
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse
  ) extends zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly {
    override val serviceSpecificCredential
        : Option[zio.aws.iam.model.ServiceSpecificCredential.ReadOnly] = scala
      .Option(impl.serviceSpecificCredential())
      .map(value => zio.aws.iam.model.ServiceSpecificCredential.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse
  ): zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly =
    new Wrapper(impl)
}
