package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ArnType,
  RoleNameType,
  IdType,
  DateType,
  PolicyDocumentType,
  PathType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RoleDetail(
    path: Option[PathType] = None,
    roleName: Option[RoleNameType] = None,
    roleId: Option[IdType] = None,
    arn: Option[ArnType] = None,
    createDate: Option[DateType] = None,
    assumeRolePolicyDocument: Option[PolicyDocumentType] = None,
    instanceProfileList: Option[Iterable[zio.aws.iam.model.InstanceProfile]] =
      None,
    rolePolicyList: Option[Iterable[zio.aws.iam.model.PolicyDetail]] = None,
    attachedManagedPolicies: Option[
      Iterable[zio.aws.iam.model.AttachedPolicy]
    ] = None,
    permissionsBoundary: Option[zio.aws.iam.model.AttachedPermissionsBoundary] =
      None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None,
    roleLastUsed: Option[zio.aws.iam.model.RoleLastUsed] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.RoleDetail = {
    import RoleDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.RoleDetail
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        roleName.map(value => RoleNameType.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        roleId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.roleId)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        assumeRolePolicyDocument.map(value =>
          PolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.assumeRolePolicyDocument)
      .optionallyWith(
        instanceProfileList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceProfileList)
      .optionallyWith(
        rolePolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rolePolicyList)
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(roleLastUsed.map(value => value.buildAwsValue()))(
        _.roleLastUsed
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.RoleDetail.ReadOnly =
    zio.aws.iam.model.RoleDetail.wrap(buildAwsValue())
}
object RoleDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.RoleDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.RoleDetail = zio.aws.iam.model.RoleDetail(
      path.map(value => value),
      roleName.map(value => value),
      roleId.map(value => value),
      arn.map(value => value),
      createDate.map(value => value),
      assumeRolePolicyDocument.map(value => value),
      instanceProfileList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      rolePolicyList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      attachedManagedPolicies.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      permissionsBoundary.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      roleLastUsed.map(value => value.asEditable)
    )
    def path: Option[PathType]
    def roleName: Option[RoleNameType]
    def roleId: Option[IdType]
    def arn: Option[ArnType]
    def createDate: Option[DateType]
    def assumeRolePolicyDocument: Option[PolicyDocumentType]
    def instanceProfileList
        : Option[List[zio.aws.iam.model.InstanceProfile.ReadOnly]]
    def rolePolicyList: Option[List[zio.aws.iam.model.PolicyDetail.ReadOnly]]
    def attachedManagedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]]
    def permissionsBoundary
        : Option[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def roleLastUsed: Option[zio.aws.iam.model.RoleLastUsed.ReadOnly]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getRoleName: ZIO[Any, AwsError, RoleNameType] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getRoleId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("roleId", roleId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getAssumeRolePolicyDocument: ZIO[Any, AwsError, PolicyDocumentType] =
      AwsError.unwrapOptionField(
        "assumeRolePolicyDocument",
        assumeRolePolicyDocument
      )
    def getInstanceProfileList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.InstanceProfile.ReadOnly]] =
      AwsError.unwrapOptionField("instanceProfileList", instanceProfileList)
    def getRolePolicyList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyDetail.ReadOnly]] =
      AwsError.unwrapOptionField("rolePolicyList", rolePolicyList)
    def getAttachedManagedPolicies
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      AwsError.unwrapOptionField(
        "attachedManagedPolicies",
        attachedManagedPolicies
      )
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRoleLastUsed
        : ZIO[Any, AwsError, zio.aws.iam.model.RoleLastUsed.ReadOnly] =
      AwsError.unwrapOptionField("roleLastUsed", roleLastUsed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.RoleDetail
  ) extends zio.aws.iam.model.RoleDetail.ReadOnly {
    override val path: Option[PathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val roleName: Option[RoleNameType] = scala
      .Option(impl.roleName())
      .map(value => zio.aws.iam.model.primitives.RoleNameType(value))
    override val roleId: Option[IdType] = scala
      .Option(impl.roleId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val assumeRolePolicyDocument: Option[PolicyDocumentType] = scala
      .Option(impl.assumeRolePolicyDocument())
      .map(value => zio.aws.iam.model.primitives.PolicyDocumentType(value))
    override val instanceProfileList
        : Option[List[zio.aws.iam.model.InstanceProfile.ReadOnly]] = scala
      .Option(impl.instanceProfileList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.InstanceProfile.wrap(item)
        }.toList
      )
    override val rolePolicyList
        : Option[List[zio.aws.iam.model.PolicyDetail.ReadOnly]] = scala
      .Option(impl.rolePolicyList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyDetail.wrap(item)
        }.toList
      )
    override val attachedManagedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] = scala
      .Option(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.AttachedPolicy.wrap(item)
        }.toList
      )
    override val permissionsBoundary
        : Option[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly] = scala
      .Option(impl.permissionsBoundary())
      .map(value => zio.aws.iam.model.AttachedPermissionsBoundary.wrap(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
    override val roleLastUsed: Option[zio.aws.iam.model.RoleLastUsed.ReadOnly] =
      scala
        .Option(impl.roleLastUsed())
        .map(value => zio.aws.iam.model.RoleLastUsed.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.RoleDetail
  ): zio.aws.iam.model.RoleDetail.ReadOnly = new Wrapper(impl)
}
