package zio.aws.iam.model
import zio.aws.iam.model.primitives.{StringType, DateType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RoleLastUsed(
    lastUsedDate: Option[DateType] = None,
    region: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.RoleLastUsed = {
    import RoleLastUsed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.RoleLastUsed
      .builder()
      .optionallyWith(
        lastUsedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastUsedDate)
      .optionallyWith(
        region.map(value => StringType.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.RoleLastUsed.ReadOnly =
    zio.aws.iam.model.RoleLastUsed.wrap(buildAwsValue())
}
object RoleLastUsed {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.RoleLastUsed] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.RoleLastUsed =
      zio.aws.iam.model.RoleLastUsed(
        lastUsedDate.map(value => value),
        region.map(value => value)
      )
    def lastUsedDate: Option[DateType]
    def region: Option[StringType]
    def getLastUsedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUsedDate", lastUsedDate)
    def getRegion: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.RoleLastUsed
  ) extends zio.aws.iam.model.RoleLastUsed.ReadOnly {
    override val lastUsedDate: Option[DateType] = scala
      .Option(impl.lastUsedDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val region: Option[StringType] = scala
      .Option(impl.region())
      .map(value => zio.aws.iam.model.primitives.StringType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.RoleLastUsed
  ): zio.aws.iam.model.RoleLastUsed.ReadOnly = new Wrapper(impl)
}
