package zio.aws.iam.model
import zio.aws.iam.model.primitives.{DateType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SAMLProviderListEntry(
    arn: Option[ArnType] = None,
    validUntil: Option[DateType] = None,
    createDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SAMLProviderListEntry = {
    import SAMLProviderListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
      .builder()
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(validUntil.map(value => DateType.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SAMLProviderListEntry.ReadOnly =
    zio.aws.iam.model.SAMLProviderListEntry.wrap(buildAwsValue())
}
object SAMLProviderListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SAMLProviderListEntry =
      zio.aws.iam.model.SAMLProviderListEntry(
        arn.map(value => value),
        validUntil.map(value => value),
        createDate.map(value => value)
      )
    def arn: Option[ArnType]
    def validUntil: Option[DateType]
    def createDate: Option[DateType]
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getValidUntil: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
  ) extends zio.aws.iam.model.SAMLProviderListEntry.ReadOnly {
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val validUntil: Option[DateType] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
  ): zio.aws.iam.model.SAMLProviderListEntry.ReadOnly = new Wrapper(impl)
}
