package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  PublicKeyFingerprintType,
  DateType,
  UserNameType,
  PublicKeyMaterialType,
  PublicKeyIdType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SSHPublicKey(
    userName: UserNameType,
    sshPublicKeyId: PublicKeyIdType,
    fingerprint: PublicKeyFingerprintType,
    sshPublicKeyBody: PublicKeyMaterialType,
    status: zio.aws.iam.model.StatusType,
    uploadDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SSHPublicKey = {
    import SSHPublicKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SSHPublicKey
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .sshPublicKeyId(PublicKeyIdType.unwrap(sshPublicKeyId): java.lang.String)
      .fingerprint(
        PublicKeyFingerprintType.unwrap(fingerprint): java.lang.String
      )
      .sshPublicKeyBody(
        PublicKeyMaterialType.unwrap(sshPublicKeyBody): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(uploadDate.map(value => DateType.unwrap(value): Instant))(
        _.uploadDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SSHPublicKey.ReadOnly =
    zio.aws.iam.model.SSHPublicKey.wrap(buildAwsValue())
}
object SSHPublicKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.SSHPublicKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SSHPublicKey =
      zio.aws.iam.model.SSHPublicKey(
        userName,
        sshPublicKeyId,
        fingerprint,
        sshPublicKeyBody,
        status,
        uploadDate.map(value => value)
      )
    def userName: UserNameType
    def sshPublicKeyId: PublicKeyIdType
    def fingerprint: PublicKeyFingerprintType
    def sshPublicKeyBody: PublicKeyMaterialType
    def status: zio.aws.iam.model.StatusType
    def uploadDate: Option[DateType]
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getSshPublicKeyId: ZIO[Any, Nothing, PublicKeyIdType] =
      ZIO.succeed(sshPublicKeyId)
    def getFingerprint: ZIO[Any, Nothing, PublicKeyFingerprintType] =
      ZIO.succeed(fingerprint)
    def getSshPublicKeyBody: ZIO[Any, Nothing, PublicKeyMaterialType] =
      ZIO.succeed(sshPublicKeyBody)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
    def getUploadDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("uploadDate", uploadDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SSHPublicKey
  ) extends zio.aws.iam.model.SSHPublicKey.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val sshPublicKeyId: PublicKeyIdType =
      zio.aws.iam.model.primitives.PublicKeyIdType(impl.sshPublicKeyId())
    override val fingerprint: PublicKeyFingerprintType =
      zio.aws.iam.model.primitives.PublicKeyFingerprintType(impl.fingerprint())
    override val sshPublicKeyBody: PublicKeyMaterialType =
      zio.aws.iam.model.primitives
        .PublicKeyMaterialType(impl.sshPublicKeyBody())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
    override val uploadDate: Option[DateType] = scala
      .Option(impl.uploadDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SSHPublicKey
  ): zio.aws.iam.model.SSHPublicKey.ReadOnly = new Wrapper(impl)
}
