package zio.aws.iam.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ArnType,
  ServiceNameType,
  DateType,
  ServiceNamespaceType,
  IntegerType,
  StringType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ServiceLastAccessed(
    serviceName: ServiceNameType,
    lastAuthenticated: Option[DateType] = None,
    serviceNamespace: ServiceNamespaceType,
    lastAuthenticatedEntity: Option[ArnType] = None,
    lastAuthenticatedRegion: Option[StringType] = None,
    totalAuthenticatedEntities: Option[IntegerType] = None,
    trackedActionsLastAccessed: Option[
      Iterable[zio.aws.iam.model.TrackedActionLastAccessed]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ServiceLastAccessed = {
    import ServiceLastAccessed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ServiceLastAccessed
      .builder()
      .serviceName(ServiceNameType.unwrap(serviceName): java.lang.String)
      .optionallyWith(
        lastAuthenticated.map(value => DateType.unwrap(value): Instant)
      )(_.lastAuthenticated)
      .serviceNamespace(
        ServiceNamespaceType.unwrap(serviceNamespace): java.lang.String
      )
      .optionallyWith(
        lastAuthenticatedEntity.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.lastAuthenticatedEntity)
      .optionallyWith(
        lastAuthenticatedRegion.map(value =>
          StringType.unwrap(value): java.lang.String
        )
      )(_.lastAuthenticatedRegion)
      .optionallyWith(
        totalAuthenticatedEntities.map(value =>
          IntegerType.unwrap(value): Integer
        )
      )(_.totalAuthenticatedEntities)
      .optionallyWith(
        trackedActionsLastAccessed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trackedActionsLastAccessed)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ServiceLastAccessed.ReadOnly =
    zio.aws.iam.model.ServiceLastAccessed.wrap(buildAwsValue())
}
object ServiceLastAccessed {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ServiceLastAccessed
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ServiceLastAccessed =
      zio.aws.iam.model.ServiceLastAccessed(
        serviceName,
        lastAuthenticated.map(value => value),
        serviceNamespace,
        lastAuthenticatedEntity.map(value => value),
        lastAuthenticatedRegion.map(value => value),
        totalAuthenticatedEntities.map(value => value),
        trackedActionsLastAccessed.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceName: ServiceNameType
    def lastAuthenticated: Option[DateType]
    def serviceNamespace: ServiceNamespaceType
    def lastAuthenticatedEntity: Option[ArnType]
    def lastAuthenticatedRegion: Option[StringType]
    def totalAuthenticatedEntities: Option[IntegerType]
    def trackedActionsLastAccessed
        : Option[List[zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly]]
    def getServiceName: ZIO[Any, Nothing, ServiceNameType] =
      ZIO.succeed(serviceName)
    def getLastAuthenticated: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastAuthenticated", lastAuthenticated)
    def getServiceNamespace: ZIO[Any, Nothing, ServiceNamespaceType] =
      ZIO.succeed(serviceNamespace)
    def getLastAuthenticatedEntity: ZIO[Any, AwsError, ArnType] = AwsError
      .unwrapOptionField("lastAuthenticatedEntity", lastAuthenticatedEntity)
    def getLastAuthenticatedRegion: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("lastAuthenticatedRegion", lastAuthenticatedRegion)
    def getTotalAuthenticatedEntities: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField(
        "totalAuthenticatedEntities",
        totalAuthenticatedEntities
      )
    def getTrackedActionsLastAccessed: ZIO[Any, AwsError, List[
      zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trackedActionsLastAccessed",
      trackedActionsLastAccessed
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ServiceLastAccessed
  ) extends zio.aws.iam.model.ServiceLastAccessed.ReadOnly {
    override val serviceName: ServiceNameType =
      zio.aws.iam.model.primitives.ServiceNameType(impl.serviceName())
    override val lastAuthenticated: Option[DateType] = scala
      .Option(impl.lastAuthenticated())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val serviceNamespace: ServiceNamespaceType =
      zio.aws.iam.model.primitives.ServiceNamespaceType(impl.serviceNamespace())
    override val lastAuthenticatedEntity: Option[ArnType] = scala
      .Option(impl.lastAuthenticatedEntity())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val lastAuthenticatedRegion: Option[StringType] = scala
      .Option(impl.lastAuthenticatedRegion())
      .map(value => zio.aws.iam.model.primitives.StringType(value))
    override val totalAuthenticatedEntities: Option[IntegerType] = scala
      .Option(impl.totalAuthenticatedEntities())
      .map(value => zio.aws.iam.model.primitives.IntegerType(value))
    override val trackedActionsLastAccessed
        : Option[List[zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly]] =
      scala
        .Option(impl.trackedActionsLastAccessed())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.TrackedActionLastAccessed.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ServiceLastAccessed
  ): zio.aws.iam.model.ServiceLastAccessed.ReadOnly = new Wrapper(impl)
}
