package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  PolicyDocumentType,
  ResourceHandlingOptionType,
  ResourceNameType,
  MarkerType,
  ActionNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SimulateCustomPolicyRequest(
    policyInputList: Iterable[PolicyDocumentType],
    permissionsBoundaryPolicyInputList: Option[Iterable[PolicyDocumentType]] =
      None,
    actionNames: Iterable[ActionNameType],
    resourceArns: Option[Iterable[ResourceNameType]] = None,
    resourcePolicy: Option[PolicyDocumentType] = None,
    resourceOwner: Option[ResourceNameType] = None,
    callerArn: Option[ResourceNameType] = None,
    contextEntries: Option[Iterable[zio.aws.iam.model.ContextEntry]] = None,
    resourceHandlingOption: Option[ResourceHandlingOptionType] = None,
    maxItems: Option[MaxItemsType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest = {
    import SimulateCustomPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest
      .builder()
      .policyInputList(policyInputList.map { item =>
        PolicyDocumentType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        permissionsBoundaryPolicyInputList.map(value =>
          value.map { item =>
            PolicyDocumentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissionsBoundaryPolicyInputList)
      .actionNames(actionNames.map { item =>
        ActionNameType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            ResourceNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .optionallyWith(
        resourcePolicy.map(value =>
          PolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.resourcePolicy)
      .optionallyWith(
        resourceOwner.map(value =>
          ResourceNameType.unwrap(value): java.lang.String
        )
      )(_.resourceOwner)
      .optionallyWith(
        callerArn.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.callerArn)
      .optionallyWith(
        contextEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contextEntries)
      .optionallyWith(
        resourceHandlingOption.map(value =>
          ResourceHandlingOptionType.unwrap(value): java.lang.String
        )
      )(_.resourceHandlingOption)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SimulateCustomPolicyRequest.ReadOnly =
    zio.aws.iam.model.SimulateCustomPolicyRequest.wrap(buildAwsValue())
}
object SimulateCustomPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SimulateCustomPolicyRequest =
      zio.aws.iam.model.SimulateCustomPolicyRequest(
        policyInputList,
        permissionsBoundaryPolicyInputList.map(value => value),
        actionNames,
        resourceArns.map(value => value),
        resourcePolicy.map(value => value),
        resourceOwner.map(value => value),
        callerArn.map(value => value),
        contextEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceHandlingOption.map(value => value),
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def policyInputList: List[PolicyDocumentType]
    def permissionsBoundaryPolicyInputList: Option[List[PolicyDocumentType]]
    def actionNames: List[ActionNameType]
    def resourceArns: Option[List[ResourceNameType]]
    def resourcePolicy: Option[PolicyDocumentType]
    def resourceOwner: Option[ResourceNameType]
    def callerArn: Option[ResourceNameType]
    def contextEntries: Option[List[zio.aws.iam.model.ContextEntry.ReadOnly]]
    def resourceHandlingOption: Option[ResourceHandlingOptionType]
    def maxItems: Option[MaxItemsType]
    def marker: Option[MarkerType]
    def getPolicyInputList: ZIO[Any, Nothing, List[PolicyDocumentType]] =
      ZIO.succeed(policyInputList)
    def getPermissionsBoundaryPolicyInputList
        : ZIO[Any, AwsError, List[PolicyDocumentType]] =
      AwsError.unwrapOptionField(
        "permissionsBoundaryPolicyInputList",
        permissionsBoundaryPolicyInputList
      )
    def getActionNames: ZIO[Any, Nothing, List[ActionNameType]] =
      ZIO.succeed(actionNames)
    def getResourceArns: ZIO[Any, AwsError, List[ResourceNameType]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
    def getResourcePolicy: ZIO[Any, AwsError, PolicyDocumentType] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
    def getResourceOwner: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
    def getCallerArn: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("callerArn", callerArn)
    def getContextEntries
        : ZIO[Any, AwsError, List[zio.aws.iam.model.ContextEntry.ReadOnly]] =
      AwsError.unwrapOptionField("contextEntries", contextEntries)
    def getResourceHandlingOption
        : ZIO[Any, AwsError, ResourceHandlingOptionType] = AwsError
      .unwrapOptionField("resourceHandlingOption", resourceHandlingOption)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest
  ) extends zio.aws.iam.model.SimulateCustomPolicyRequest.ReadOnly {
    override val policyInputList: List[PolicyDocumentType] = impl
      .policyInputList()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.PolicyDocumentType(item)
      }
      .toList
    override val permissionsBoundaryPolicyInputList
        : Option[List[PolicyDocumentType]] = scala
      .Option(impl.permissionsBoundaryPolicyInputList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.PolicyDocumentType(item)
        }.toList
      )
    override val actionNames: List[ActionNameType] = impl
      .actionNames()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.ActionNameType(item)
      }
      .toList
    override val resourceArns: Option[List[ResourceNameType]] = scala
      .Option(impl.resourceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.ResourceNameType(item)
        }.toList
      )
    override val resourcePolicy: Option[PolicyDocumentType] = scala
      .Option(impl.resourcePolicy())
      .map(value => zio.aws.iam.model.primitives.PolicyDocumentType(value))
    override val resourceOwner: Option[ResourceNameType] = scala
      .Option(impl.resourceOwner())
      .map(value => zio.aws.iam.model.primitives.ResourceNameType(value))
    override val callerArn: Option[ResourceNameType] = scala
      .Option(impl.callerArn())
      .map(value => zio.aws.iam.model.primitives.ResourceNameType(value))
    override val contextEntries
        : Option[List[zio.aws.iam.model.ContextEntry.ReadOnly]] = scala
      .Option(impl.contextEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.ContextEntry.wrap(item)
        }.toList
      )
    override val resourceHandlingOption: Option[ResourceHandlingOptionType] =
      scala
        .Option(impl.resourceHandlingOption())
        .map(value =>
          zio.aws.iam.model.primitives.ResourceHandlingOptionType(value)
        )
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest
  ): zio.aws.iam.model.SimulateCustomPolicyRequest.ReadOnly = new Wrapper(impl)
}
