package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SimulateCustomPolicyResponse(
    evaluationResults: Option[Iterable[zio.aws.iam.model.EvaluationResult]] =
      None,
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse = {
    import SimulateCustomPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse
      .builder()
      .optionallyWith(
        evaluationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluationResults)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly =
    zio.aws.iam.model.SimulateCustomPolicyResponse.wrap(buildAwsValue())
}
object SimulateCustomPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SimulateCustomPolicyResponse =
      zio.aws.iam.model.SimulateCustomPolicyResponse(
        evaluationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def evaluationResults
        : Option[List[zio.aws.iam.model.EvaluationResult.ReadOnly]]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getEvaluationResults: ZIO[Any, AwsError, List[
      zio.aws.iam.model.EvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluationResults", evaluationResults)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse
  ) extends zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly {
    override val evaluationResults
        : Option[List[zio.aws.iam.model.EvaluationResult.ReadOnly]] = scala
      .Option(impl.evaluationResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.EvaluationResult.wrap(item)
        }.toList
      )
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse
  ): zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly = new Wrapper(impl)
}
