package zio.aws.iam.model
import zio.aws.iam.model.primitives.PolicyIdentifierType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Statement(
    sourcePolicyId: Option[PolicyIdentifierType] = None,
    sourcePolicyType: Option[zio.aws.iam.model.PolicySourceType] = None,
    startPosition: Option[zio.aws.iam.model.Position] = None,
    endPosition: Option[zio.aws.iam.model.Position] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.Statement = {
    import Statement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.Statement
      .builder()
      .optionallyWith(
        sourcePolicyId.map(value =>
          PolicyIdentifierType.unwrap(value): java.lang.String
        )
      )(_.sourcePolicyId)
      .optionallyWith(sourcePolicyType.map(value => value.unwrap))(
        _.sourcePolicyType
      )
      .optionallyWith(startPosition.map(value => value.buildAwsValue()))(
        _.startPosition
      )
      .optionallyWith(endPosition.map(value => value.buildAwsValue()))(
        _.endPosition
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.Statement.ReadOnly =
    zio.aws.iam.model.Statement.wrap(buildAwsValue())
}
object Statement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.Statement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.Statement = zio.aws.iam.model.Statement(
      sourcePolicyId.map(value => value),
      sourcePolicyType.map(value => value),
      startPosition.map(value => value.asEditable),
      endPosition.map(value => value.asEditable)
    )
    def sourcePolicyId: Option[PolicyIdentifierType]
    def sourcePolicyType: Option[zio.aws.iam.model.PolicySourceType]
    def startPosition: Option[zio.aws.iam.model.Position.ReadOnly]
    def endPosition: Option[zio.aws.iam.model.Position.ReadOnly]
    def getSourcePolicyId: ZIO[Any, AwsError, PolicyIdentifierType] =
      AwsError.unwrapOptionField("sourcePolicyId", sourcePolicyId)
    def getSourcePolicyType
        : ZIO[Any, AwsError, zio.aws.iam.model.PolicySourceType] =
      AwsError.unwrapOptionField("sourcePolicyType", sourcePolicyType)
    def getStartPosition
        : ZIO[Any, AwsError, zio.aws.iam.model.Position.ReadOnly] =
      AwsError.unwrapOptionField("startPosition", startPosition)
    def getEndPosition
        : ZIO[Any, AwsError, zio.aws.iam.model.Position.ReadOnly] =
      AwsError.unwrapOptionField("endPosition", endPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.Statement
  ) extends zio.aws.iam.model.Statement.ReadOnly {
    override val sourcePolicyId: Option[PolicyIdentifierType] = scala
      .Option(impl.sourcePolicyId())
      .map(value => zio.aws.iam.model.primitives.PolicyIdentifierType(value))
    override val sourcePolicyType: Option[zio.aws.iam.model.PolicySourceType] =
      scala
        .Option(impl.sourcePolicyType())
        .map(value => zio.aws.iam.model.PolicySourceType.wrap(value))
    override val startPosition: Option[zio.aws.iam.model.Position.ReadOnly] =
      scala
        .Option(impl.startPosition())
        .map(value => zio.aws.iam.model.Position.wrap(value))
    override val endPosition: Option[zio.aws.iam.model.Position.ReadOnly] =
      scala
        .Option(impl.endPosition())
        .map(value => zio.aws.iam.model.Position.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.Statement
  ): zio.aws.iam.model.Statement.ReadOnly = new Wrapper(impl)
}
