package zio.aws.iam.model
import zio.aws.iam.model.primitives.{DateType, ArnType, StringType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TrackedActionLastAccessed(
    actionName: Option[StringType] = None,
    lastAccessedEntity: Option[ArnType] = None,
    lastAccessedTime: Option[DateType] = None,
    lastAccessedRegion: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed = {
    import TrackedActionLastAccessed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
      .builder()
      .optionallyWith(
        actionName.map(value => StringType.unwrap(value): java.lang.String)
      )(_.actionName)
      .optionallyWith(
        lastAccessedEntity.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.lastAccessedEntity)
      .optionallyWith(
        lastAccessedTime.map(value => DateType.unwrap(value): Instant)
      )(_.lastAccessedTime)
      .optionallyWith(
        lastAccessedRegion.map(value =>
          StringType.unwrap(value): java.lang.String
        )
      )(_.lastAccessedRegion)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly =
    zio.aws.iam.model.TrackedActionLastAccessed.wrap(buildAwsValue())
}
object TrackedActionLastAccessed {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TrackedActionLastAccessed =
      zio.aws.iam.model.TrackedActionLastAccessed(
        actionName.map(value => value),
        lastAccessedEntity.map(value => value),
        lastAccessedTime.map(value => value),
        lastAccessedRegion.map(value => value)
      )
    def actionName: Option[StringType]
    def lastAccessedEntity: Option[ArnType]
    def lastAccessedTime: Option[DateType]
    def lastAccessedRegion: Option[StringType]
    def getActionName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getLastAccessedEntity: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("lastAccessedEntity", lastAccessedEntity)
    def getLastAccessedTime: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastAccessedTime", lastAccessedTime)
    def getLastAccessedRegion: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("lastAccessedRegion", lastAccessedRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
  ) extends zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly {
    override val actionName: Option[StringType] = scala
      .Option(impl.actionName())
      .map(value => zio.aws.iam.model.primitives.StringType(value))
    override val lastAccessedEntity: Option[ArnType] = scala
      .Option(impl.lastAccessedEntity())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val lastAccessedTime: Option[DateType] = scala
      .Option(impl.lastAccessedTime())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val lastAccessedRegion: Option[StringType] = scala
      .Option(impl.lastAccessedRegion())
      .map(value => zio.aws.iam.model.primitives.StringType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
  ): zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly = new Wrapper(impl)
}
