package zio.aws.iam.model
import zio.aws.iam.model.primitives.{AccessKeyIdType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAccessKeyRequest(
    userName: Option[ExistingUserNameType] = None,
    accessKeyId: AccessKeyIdType,
    status: zio.aws.iam.model.StatusType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest = {
    import UpdateAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .accessKeyId(AccessKeyIdType.unwrap(accessKeyId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateAccessKeyRequest.ReadOnly =
    zio.aws.iam.model.UpdateAccessKeyRequest.wrap(buildAwsValue())
}
object UpdateAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateAccessKeyRequest = zio.aws.iam.model
      .UpdateAccessKeyRequest(userName.map(value => value), accessKeyId, status)
    def userName: Option[ExistingUserNameType]
    def accessKeyId: AccessKeyIdType
    def status: zio.aws.iam.model.StatusType
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyIdType] =
      ZIO.succeed(accessKeyId)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest
  ) extends zio.aws.iam.model.UpdateAccessKeyRequest.ReadOnly {
    override val userName: Option[ExistingUserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val accessKeyId: AccessKeyIdType =
      zio.aws.iam.model.primitives.AccessKeyIdType(impl.accessKeyId())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest
  ): zio.aws.iam.model.UpdateAccessKeyRequest.ReadOnly = new Wrapper(impl)
}
