package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyDocumentType, RoleNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAssumeRolePolicyRequest(
    roleName: RoleNameType,
    policyDocument: PolicyDocumentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest = {
    import UpdateAssumeRolePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .policyDocument(
        PolicyDocumentType.unwrap(policyDocument): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateAssumeRolePolicyRequest.ReadOnly =
    zio.aws.iam.model.UpdateAssumeRolePolicyRequest.wrap(buildAwsValue())
}
object UpdateAssumeRolePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateAssumeRolePolicyRequest =
      zio.aws.iam.model.UpdateAssumeRolePolicyRequest(roleName, policyDocument)
    def roleName: RoleNameType
    def policyDocument: PolicyDocumentType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest
  ) extends zio.aws.iam.model.UpdateAssumeRolePolicyRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val policyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest
  ): zio.aws.iam.model.UpdateAssumeRolePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
