package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PathType, GroupNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateGroupRequest(
    groupName: GroupNameType,
    newPath: Option[PathType] = None,
    newGroupName: Option[GroupNameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateGroupRequest = {
    import UpdateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateGroupRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .optionallyWith(
        newPath.map(value => PathType.unwrap(value): java.lang.String)
      )(_.newPath)
      .optionallyWith(
        newGroupName.map(value => GroupNameType.unwrap(value): java.lang.String)
      )(_.newGroupName)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateGroupRequest.ReadOnly =
    zio.aws.iam.model.UpdateGroupRequest.wrap(buildAwsValue())
}
object UpdateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateGroupRequest =
      zio.aws.iam.model.UpdateGroupRequest(
        groupName,
        newPath.map(value => value),
        newGroupName.map(value => value)
      )
    def groupName: GroupNameType
    def newPath: Option[PathType]
    def newGroupName: Option[GroupNameType]
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getNewPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("newPath", newPath)
    def getNewGroupName: ZIO[Any, AwsError, GroupNameType] =
      AwsError.unwrapOptionField("newGroupName", newGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateGroupRequest
  ) extends zio.aws.iam.model.UpdateGroupRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val newPath: Option[PathType] = scala
      .Option(impl.newPath())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val newGroupName: Option[GroupNameType] = scala
      .Option(impl.newGroupName())
      .map(value => zio.aws.iam.model.primitives.GroupNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateGroupRequest
  ): zio.aws.iam.model.UpdateGroupRequest.ReadOnly = new Wrapper(impl)
}
