package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  RoleMaxSessionDurationType,
  RoleDescriptionType,
  RoleNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateRoleRequest(
    roleName: RoleNameType,
    description: Option[RoleDescriptionType] = None,
    maxSessionDuration: Option[RoleMaxSessionDurationType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateRoleRequest = {
    import UpdateRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RoleDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        maxSessionDuration.map(value =>
          RoleMaxSessionDurationType.unwrap(value): Integer
        )
      )(_.maxSessionDuration)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateRoleRequest.ReadOnly =
    zio.aws.iam.model.UpdateRoleRequest.wrap(buildAwsValue())
}
object UpdateRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateRoleRequest =
      zio.aws.iam.model.UpdateRoleRequest(
        roleName,
        description.map(value => value),
        maxSessionDuration.map(value => value)
      )
    def roleName: RoleNameType
    def description: Option[RoleDescriptionType]
    def maxSessionDuration: Option[RoleMaxSessionDurationType]
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getDescription: ZIO[Any, AwsError, RoleDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getMaxSessionDuration: ZIO[Any, AwsError, RoleMaxSessionDurationType] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleRequest
  ) extends zio.aws.iam.model.UpdateRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val description: Option[RoleDescriptionType] = scala
      .Option(impl.description())
      .map(value => zio.aws.iam.model.primitives.RoleDescriptionType(value))
    override val maxSessionDuration: Option[RoleMaxSessionDurationType] = scala
      .Option(impl.maxSessionDuration())
      .map(value =>
        zio.aws.iam.model.primitives.RoleMaxSessionDurationType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleRequest
  ): zio.aws.iam.model.UpdateRoleRequest.ReadOnly = new Wrapper(impl)
}
