package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, SAMLMetadataDocumentType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSamlProviderRequest(
    samlMetadataDocument: SAMLMetadataDocumentType,
    samlProviderArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest = {
    import UpdateSamlProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest
      .builder()
      .samlMetadataDocument(
        SAMLMetadataDocumentType.unwrap(samlMetadataDocument): java.lang.String
      )
      .samlProviderArn(ArnType.unwrap(samlProviderArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateSamlProviderRequest.ReadOnly =
    zio.aws.iam.model.UpdateSamlProviderRequest.wrap(buildAwsValue())
}
object UpdateSamlProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateSamlProviderRequest =
      zio.aws.iam.model
        .UpdateSamlProviderRequest(samlMetadataDocument, samlProviderArn)
    def samlMetadataDocument: SAMLMetadataDocumentType
    def samlProviderArn: ArnType
    def getSamlMetadataDocument: ZIO[Any, Nothing, SAMLMetadataDocumentType] =
      ZIO.succeed(samlMetadataDocument)
    def getSamlProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(samlProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest
  ) extends zio.aws.iam.model.UpdateSamlProviderRequest.ReadOnly {
    override val samlMetadataDocument: SAMLMetadataDocumentType =
      zio.aws.iam.model.primitives
        .SAMLMetadataDocumentType(impl.samlMetadataDocument())
    override val samlProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.samlProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest
  ): zio.aws.iam.model.UpdateSamlProviderRequest.ReadOnly = new Wrapper(impl)
}
