package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  PrivateKeyType,
  CertificateChainType,
  CertificateBodyType,
  PathType,
  ServerCertificateNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UploadServerCertificateRequest(
    path: Option[PathType] = None,
    serverCertificateName: ServerCertificateNameType,
    certificateBody: CertificateBodyType,
    privateKey: PrivateKeyType,
    certificateChain: Option[CertificateChainType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest = {
    import UploadServerCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .certificateBody(
        CertificateBodyType.unwrap(certificateBody): java.lang.String
      )
      .privateKey(PrivateKeyType.unwrap(privateKey): java.lang.String)
      .optionallyWith(
        certificateChain.map(value =>
          CertificateChainType.unwrap(value): java.lang.String
        )
      )(_.certificateChain)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UploadServerCertificateRequest.ReadOnly =
    zio.aws.iam.model.UploadServerCertificateRequest.wrap(buildAwsValue())
}
object UploadServerCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UploadServerCertificateRequest =
      zio.aws.iam.model.UploadServerCertificateRequest(
        path.map(value => value),
        serverCertificateName,
        certificateBody,
        privateKey,
        certificateChain.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: Option[PathType]
    def serverCertificateName: ServerCertificateNameType
    def certificateBody: CertificateBodyType
    def privateKey: PrivateKeyType
    def certificateChain: Option[CertificateChainType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
    def getCertificateBody: ZIO[Any, Nothing, CertificateBodyType] =
      ZIO.succeed(certificateBody)
    def getPrivateKey: ZIO[Any, Nothing, PrivateKeyType] =
      ZIO.succeed(privateKey)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChainType] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest
  ) extends zio.aws.iam.model.UploadServerCertificateRequest.ReadOnly {
    override val path: Option[PathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
    override val certificateBody: CertificateBodyType =
      zio.aws.iam.model.primitives.CertificateBodyType(impl.certificateBody())
    override val privateKey: PrivateKeyType =
      zio.aws.iam.model.primitives.PrivateKeyType(impl.privateKey())
    override val certificateChain: Option[CertificateChainType] = scala
      .Option(impl.certificateChain())
      .map(value => zio.aws.iam.model.primitives.CertificateChainType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest
  ): zio.aws.iam.model.UploadServerCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
