package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UploadServerCertificateResponse(
    serverCertificateMetadata: Option[
      zio.aws.iam.model.ServerCertificateMetadata
    ] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse = {
    import UploadServerCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
      .builder()
      .optionallyWith(
        serverCertificateMetadata.map(value => value.buildAwsValue())
      )(_.serverCertificateMetadata)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly =
    zio.aws.iam.model.UploadServerCertificateResponse.wrap(buildAwsValue())
}
object UploadServerCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UploadServerCertificateResponse =
      zio.aws.iam.model.UploadServerCertificateResponse(
        serverCertificateMetadata.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverCertificateMetadata
        : Option[zio.aws.iam.model.ServerCertificateMetadata.ReadOnly]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getServerCertificateMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverCertificateMetadata",
      serverCertificateMetadata
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
  ) extends zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly {
    override val serverCertificateMetadata
        : Option[zio.aws.iam.model.ServerCertificateMetadata.ReadOnly] = scala
      .Option(impl.serverCertificateMetadata())
      .map(value => zio.aws.iam.model.ServerCertificateMetadata.wrap(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
  ): zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
