package zio.aws.iam.model
import zio.aws.iam.model.primitives.{CertificateBodyType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UploadSigningCertificateRequest(
    userName: Option[ExistingUserNameType] = None,
    certificateBody: CertificateBodyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest = {
    import UploadSigningCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .certificateBody(
        CertificateBodyType.unwrap(certificateBody): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UploadSigningCertificateRequest.ReadOnly =
    zio.aws.iam.model.UploadSigningCertificateRequest.wrap(buildAwsValue())
}
object UploadSigningCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UploadSigningCertificateRequest =
      zio.aws.iam.model.UploadSigningCertificateRequest(
        userName.map(value => value),
        certificateBody
      )
    def userName: Option[ExistingUserNameType]
    def certificateBody: CertificateBodyType
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getCertificateBody: ZIO[Any, Nothing, CertificateBodyType] =
      ZIO.succeed(certificateBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest
  ) extends zio.aws.iam.model.UploadSigningCertificateRequest.ReadOnly {
    override val userName: Option[ExistingUserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val certificateBody: CertificateBodyType =
      zio.aws.iam.model.primitives.CertificateBodyType(impl.certificateBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest
  ): zio.aws.iam.model.UploadSigningCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
