package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UploadSshPublicKeyResponse(
    sshPublicKey: Option[zio.aws.iam.model.SSHPublicKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse = {
    import UploadSshPublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse
      .builder()
      .optionallyWith(sshPublicKey.map(value => value.buildAwsValue()))(
        _.sshPublicKey
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly =
    zio.aws.iam.model.UploadSshPublicKeyResponse.wrap(buildAwsValue())
}
object UploadSshPublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UploadSshPublicKeyResponse =
      zio.aws.iam.model
        .UploadSshPublicKeyResponse(sshPublicKey.map(value => value.asEditable))
    def sshPublicKey: Option[zio.aws.iam.model.SSHPublicKey.ReadOnly]
    def getSshPublicKey
        : ZIO[Any, AwsError, zio.aws.iam.model.SSHPublicKey.ReadOnly] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse
  ) extends zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly {
    override val sshPublicKey: Option[zio.aws.iam.model.SSHPublicKey.ReadOnly] =
      scala
        .Option(impl.sshPublicKey())
        .map(value => zio.aws.iam.model.SSHPublicKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse
  ): zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly = new Wrapper(impl)
}
