package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ArnType,
  IdType,
  DateType,
  UserNameType,
  PathType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class User(
    path: PathType,
    userName: UserNameType,
    userId: IdType,
    arn: ArnType,
    createDate: DateType,
    passwordLastUsed: Option[DateType] = None,
    permissionsBoundary: Option[zio.aws.iam.model.AttachedPermissionsBoundary] =
      None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.User
      .builder()
      .path(PathType.unwrap(path): java.lang.String)
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .userId(IdType.unwrap(userId): java.lang.String)
      .arn(ArnType.unwrap(arn): java.lang.String)
      .createDate(DateType.unwrap(createDate): Instant)
      .optionallyWith(
        passwordLastUsed.map(value => DateType.unwrap(value): Instant)
      )(_.passwordLastUsed)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.User.ReadOnly =
    zio.aws.iam.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.User = zio.aws.iam.model.User(
      path,
      userName,
      userId,
      arn,
      createDate,
      passwordLastUsed.map(value => value),
      permissionsBoundary.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def path: PathType
    def userName: UserNameType
    def userId: IdType
    def arn: ArnType
    def createDate: DateType
    def passwordLastUsed: Option[DateType]
    def permissionsBoundary
        : Option[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, Nothing, PathType] = ZIO.succeed(path)
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getUserId: ZIO[Any, Nothing, IdType] = ZIO.succeed(userId)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getCreateDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(createDate)
    def getPasswordLastUsed: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("passwordLastUsed", passwordLastUsed)
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.User
  ) extends zio.aws.iam.model.User.ReadOnly {
    override val path: PathType =
      zio.aws.iam.model.primitives.PathType(impl.path())
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val userId: IdType =
      zio.aws.iam.model.primitives.IdType(impl.userId())
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val createDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.createDate())
    override val passwordLastUsed: Option[DateType] = scala
      .Option(impl.passwordLastUsed())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val permissionsBoundary
        : Option[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly] = scala
      .Option(impl.permissionsBoundary())
      .map(value => zio.aws.iam.model.AttachedPermissionsBoundary.wrap(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.User
  ): zio.aws.iam.model.User.ReadOnly = new Wrapper(impl)
}
