package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ArnType,
  IdType,
  DateType,
  UserNameType,
  GroupNameType,
  PathType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UserDetail(
    path: Option[PathType] = None,
    userName: Option[UserNameType] = None,
    userId: Option[IdType] = None,
    arn: Option[ArnType] = None,
    createDate: Option[DateType] = None,
    userPolicyList: Option[Iterable[zio.aws.iam.model.PolicyDetail]] = None,
    groupList: Option[Iterable[GroupNameType]] = None,
    attachedManagedPolicies: Option[
      Iterable[zio.aws.iam.model.AttachedPolicy]
    ] = None,
    permissionsBoundary: Option[zio.aws.iam.model.AttachedPermissionsBoundary] =
      None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.UserDetail = {
    import UserDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UserDetail
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        userId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        userPolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userPolicyList)
      .optionallyWith(
        groupList.map(value =>
          value.map { item =>
            GroupNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupList)
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UserDetail.ReadOnly =
    zio.aws.iam.model.UserDetail.wrap(buildAwsValue())
}
object UserDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.UserDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UserDetail = zio.aws.iam.model.UserDetail(
      path.map(value => value),
      userName.map(value => value),
      userId.map(value => value),
      arn.map(value => value),
      createDate.map(value => value),
      userPolicyList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      groupList.map(value => value),
      attachedManagedPolicies.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      permissionsBoundary.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def path: Option[PathType]
    def userName: Option[UserNameType]
    def userId: Option[IdType]
    def arn: Option[ArnType]
    def createDate: Option[DateType]
    def userPolicyList: Option[List[zio.aws.iam.model.PolicyDetail.ReadOnly]]
    def groupList: Option[List[GroupNameType]]
    def attachedManagedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]]
    def permissionsBoundary
        : Option[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getUserId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("userId", userId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getUserPolicyList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyDetail.ReadOnly]] =
      AwsError.unwrapOptionField("userPolicyList", userPolicyList)
    def getGroupList: ZIO[Any, AwsError, List[GroupNameType]] =
      AwsError.unwrapOptionField("groupList", groupList)
    def getAttachedManagedPolicies
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      AwsError.unwrapOptionField(
        "attachedManagedPolicies",
        attachedManagedPolicies
      )
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UserDetail
  ) extends zio.aws.iam.model.UserDetail.ReadOnly {
    override val path: Option[PathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val userName: Option[UserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val userId: Option[IdType] = scala
      .Option(impl.userId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val userPolicyList
        : Option[List[zio.aws.iam.model.PolicyDetail.ReadOnly]] = scala
      .Option(impl.userPolicyList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyDetail.wrap(item)
        }.toList
      )
    override val groupList: Option[List[GroupNameType]] = scala
      .Option(impl.groupList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.GroupNameType(item)
        }.toList
      )
    override val attachedManagedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] = scala
      .Option(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.AttachedPolicy.wrap(item)
        }.toList
      )
    override val permissionsBoundary
        : Option[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly] = scala
      .Option(impl.permissionsBoundary())
      .map(value => zio.aws.iam.model.AttachedPermissionsBoundary.wrap(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UserDetail
  ): zio.aws.iam.model.UserDetail.ReadOnly = new Wrapper(impl)
}
