package zio.aws.iam.model
import zio.aws.iam.model.primitives.{DateType, BootstrapDatum, SerialNumberType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class VirtualMFADevice(
    serialNumber: SerialNumberType,
    base32StringSeed: Option[BootstrapDatum] = None,
    qrCodePNG: Option[BootstrapDatum] = None,
    user: Option[zio.aws.iam.model.User] = None,
    enableDate: Option[DateType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.VirtualMFADevice = {
    import VirtualMFADevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.VirtualMFADevice
      .builder()
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .optionallyWith(
        base32StringSeed.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.base32StringSeed)
      .optionallyWith(
        qrCodePNG.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.qrCodePNG)
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .optionallyWith(enableDate.map(value => DateType.unwrap(value): Instant))(
        _.enableDate
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.VirtualMFADevice.ReadOnly =
    zio.aws.iam.model.VirtualMFADevice.wrap(buildAwsValue())
}
object VirtualMFADevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.VirtualMFADevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.VirtualMFADevice =
      zio.aws.iam.model.VirtualMFADevice(
        serialNumber,
        base32StringSeed.map(value => value),
        qrCodePNG.map(value => value),
        user.map(value => value.asEditable),
        enableDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serialNumber: SerialNumberType
    def base32StringSeed: Option[BootstrapDatum]
    def qrCodePNG: Option[BootstrapDatum]
    def user: Option[zio.aws.iam.model.User.ReadOnly]
    def enableDate: Option[DateType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getBase32StringSeed: ZIO[Any, AwsError, BootstrapDatum] =
      AwsError.unwrapOptionField("base32StringSeed", base32StringSeed)
    def getQrCodePNG: ZIO[Any, AwsError, BootstrapDatum] =
      AwsError.unwrapOptionField("qrCodePNG", qrCodePNG)
    def getUser: ZIO[Any, AwsError, zio.aws.iam.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
    def getEnableDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("enableDate", enableDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.VirtualMFADevice
  ) extends zio.aws.iam.model.VirtualMFADevice.ReadOnly {
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val base32StringSeed: Option[BootstrapDatum] = scala
      .Option(impl.base32StringSeed())
      .map(value =>
        zio.aws.iam.model.primitives
          .BootstrapDatum(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val qrCodePNG: Option[BootstrapDatum] = scala
      .Option(impl.qrCodePNG())
      .map(value =>
        zio.aws.iam.model.primitives
          .BootstrapDatum(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val user: Option[zio.aws.iam.model.User.ReadOnly] =
      scala.Option(impl.user()).map(value => zio.aws.iam.model.User.wrap(value))
    override val enableDate: Option[DateType] = scala
      .Option(impl.enableDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.VirtualMFADevice
  ): zio.aws.iam.model.VirtualMFADevice.ReadOnly = new Wrapper(impl)
}
