package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateOpenIdConnectProviderResponse(
    openIDConnectProviderArn: Optional[ArnType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse = {
    import CreateOpenIdConnectProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse
      .builder()
      .optionallyWith(
        openIDConnectProviderArn.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.openIDConnectProviderArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly =
    zio.aws.iam.model.CreateOpenIdConnectProviderResponse.wrap(buildAwsValue())
}
object CreateOpenIdConnectProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateOpenIdConnectProviderResponse =
      zio.aws.iam.model.CreateOpenIdConnectProviderResponse(
        openIDConnectProviderArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def openIDConnectProviderArn: Optional[ArnType]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getOpenIDConnectProviderArn: ZIO[Any, AwsError, ArnType] = AwsError
      .unwrapOptionField("openIDConnectProviderArn", openIDConnectProviderArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse
  ) extends zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly {
    override val openIDConnectProviderArn: Optional[ArnType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openIDConnectProviderArn())
        .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse
  ): zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly =
    new Wrapper(impl)
}
