package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ServiceName, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateServiceSpecificCredentialRequest(
    userName: UserNameType,
    serviceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest = {
    import CreateServiceSpecificCredentialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .serviceName(ServiceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.CreateServiceSpecificCredentialRequest.ReadOnly =
    zio.aws.iam.model.CreateServiceSpecificCredentialRequest
      .wrap(buildAwsValue())
}
object CreateServiceSpecificCredentialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateServiceSpecificCredentialRequest =
      zio.aws.iam.model
        .CreateServiceSpecificCredentialRequest(userName, serviceName)
    def userName: UserNameType
    def serviceName: ServiceName
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest
  ) extends zio.aws.iam.model.CreateServiceSpecificCredentialRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val serviceName: ServiceName =
      zio.aws.iam.model.primitives.ServiceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest
  ): zio.aws.iam.model.CreateServiceSpecificCredentialRequest.ReadOnly =
    new Wrapper(impl)
}
