package zio.aws.iam.model
import zio.aws.iam.model.primitives.{SerialNumberType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeactivateMfaDeviceRequest(
    userName: ExistingUserNameType,
    serialNumber: SerialNumberType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest = {
    import DeactivateMfaDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeactivateMfaDeviceRequest.ReadOnly =
    zio.aws.iam.model.DeactivateMfaDeviceRequest.wrap(buildAwsValue())
}
object DeactivateMfaDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeactivateMfaDeviceRequest =
      zio.aws.iam.model.DeactivateMfaDeviceRequest(userName, serialNumber)
    def userName: ExistingUserNameType
    def serialNumber: SerialNumberType
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest
  ) extends zio.aws.iam.model.DeactivateMfaDeviceRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest
  ): zio.aws.iam.model.DeactivateMfaDeviceRequest.ReadOnly = new Wrapper(impl)
}
