package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeletePolicyRequest(policyArn: ArnType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeletePolicyRequest = {
    import DeletePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeletePolicyRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeletePolicyRequest.ReadOnly =
    zio.aws.iam.model.DeletePolicyRequest.wrap(buildAwsValue())
}
object DeletePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeletePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeletePolicyRequest =
      zio.aws.iam.model.DeletePolicyRequest(policyArn)
    def policyArn: ArnType
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeletePolicyRequest
  ) extends zio.aws.iam.model.DeletePolicyRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeletePolicyRequest
  ): zio.aws.iam.model.DeletePolicyRequest.ReadOnly = new Wrapper(impl)
}
