package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PathType, IdType, UserNameType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EntityInfo(
    arn: ArnType,
    name: UserNameType,
    `type`: zio.aws.iam.model.PolicyOwnerEntityType,
    id: IdType,
    path: Optional[PathType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.EntityInfo = {
    import EntityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.EntityInfo
      .builder()
      .arn(ArnType.unwrap(arn): java.lang.String)
      .name(UserNameType.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .id(IdType.unwrap(id): java.lang.String)
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.EntityInfo.ReadOnly =
    zio.aws.iam.model.EntityInfo.wrap(buildAwsValue())
}
object EntityInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.EntityInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.EntityInfo = zio.aws.iam.model.EntityInfo(
      arn,
      name,
      `type`,
      id,
      path.map(value => value)
    )
    def arn: ArnType
    def name: UserNameType
    def `type`: zio.aws.iam.model.PolicyOwnerEntityType
    def id: IdType
    def path: Optional[PathType]
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.iam.model.PolicyOwnerEntityType] =
      ZIO.succeed(`type`)
    def getId: ZIO[Any, Nothing, IdType] = ZIO.succeed(id)
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.EntityInfo
  ) extends zio.aws.iam.model.EntityInfo.ReadOnly {
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val name: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.name())
    override val `type`: zio.aws.iam.model.PolicyOwnerEntityType =
      zio.aws.iam.model.PolicyOwnerEntityType.wrap(impl.`type`())
    override val id: IdType = zio.aws.iam.model.primitives.IdType(impl.id())
    override val path: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.EntityInfo
  ): zio.aws.iam.model.EntityInfo.ReadOnly = new Wrapper(impl)
}
